





--------------------------------------------------------------------------------

GT = {};
GT_t.ws = 0;

set_recursive_metatable(GT, GT_t.generic_ship)

GT.visual = {}
GT.visual.shape = "uss_franklin"
GT.visual.shape_dstr = ""


GT.animation_arguments.radar1_rotation = 11
GT.radar1_period = 3
GT.animation_arguments.radar2_rotation = 2
GT.radar2_period = 1
GT.animation_arguments.radar3_rotation = 3
GT.radar3_period = 3
GT.animation_arguments.luna_lights = -1
GT.animation_arguments.water_propeller = 8
--GT.TACAN = true;
--GT.TACAN_position = {-55.0, 55.0, 29.0}
--GT.ICLS = true;

GT.life = 7000
GT.mass = 7.05e+007
GT.max_velocity = 16.4622
GT.race_velocity = 15.4333
GT.economy_velocity = 9.26
GT.economy_distance = 1.4816e+007
GT.race_distance = 4.63e+006
GT.shipLength = 276.6
GT.Width = 77.1
GT.Height = 53.1
GT.Length = 304.5
GT.DeckLevel = 16.257
GT.X_nose = 140            --145
GT.X_tail = -113.5
GT.Tail_Width = 28
GT.Gamma_max = 0.35
GT.Om = 0.02
GT.speedup = 0.148333
GT.R_min = 609
GT.distFindObstacles = 963.5

GT.numParking = 12			-- edited by baco30, it was 3
GT.Plane_Num_ = 24
GT.Helicopter_Num_ = 12

GT.animation_arguments.water_propeller = -1;
GT.animation_arguments.catapult_shuttles = {145, 146, 147, 148}
GT.airWeaponDist = 10000  -- edited by baco30, it was 15000
GT.airFindDist = 20000   -- edited by baco30, it was 25000

---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra
--------------------------------------------------------------------------------

GT.ArrestingGears = {
	{
		 Left = {	pos = {-65.00,    16.683, -17.50} },
		Right = {	pos = {-60.00,    16.683,  17.00} }
	},
	{
		Left = {	pos = {-51.00,   16.683, -18.50} },
		Right = {	pos = {-47.20,    16.683,  15.30} }
	},
	{
		Left = {	pos = {-38.90,   16.683, -21.50} },
		Right = {	pos = {-34.00,   16.683,  13.00} }
	},
	{
		Left = {	pos = {-65.00,  16.683, -17.50} },  
		Right = {	pos = {-60.00,  16.683,  17.00} }  
	}
}
GT.ArrestingGears.ArrestingGearsNumber = #GT.ArrestingGears
 GT.Landing_Point = {101.0, 16.20, 00.0}               
GT.LSOView = {cockpit = "empty", position = {--[[connector = "",]] offset = {13.0, 16.2, -17.9, -172.5, 4.0}}}
GT.OLS = {Type = GT_t.OLS_TYPE.Luna, MeatBallArg = 100}
--GT.Landing_Point = {-1.0, 16.25, 0.0}       --prvy_katapult{-19.931, 21.198, 6.286}


--------------------------------------------------------------------------------
GT.DM = {
----- Scafo.
	{ area_name = "Scafo_Prua_Dx",		area_arg = 76,	area_life = 70, area_fire = { pos = {45.0, 4.0, 3.0}, size = 1.5}},
	{ area_name = "Scafo_Prua_Sx", 		area_arg = 73,	area_life = 70, area_fire = { pos = {30.0, 4.0,- 3.0}, size = 1.5}},	
	{ area_name = "Scafo_Poppa_Dx", 		area_arg = 72,	area_life = 60, area_fire = { pos = {-20.0, 2.0, 3.0}, size = 1.5}},
    	{ area_name = "Scafo_Poppa_Sx", 		area_arg = 75,	area_life = 60, area_fire = { pos = {-10.0, 2.0, -3.0}, size = 1.5}},
 -------- Sovrastrutture	
	{ area_name = "Strutture_Poppa",           area_arg = 82,	area_life = 80, area_fire = { pos = {-35.0, 12.0, 0.0}, size = 1.5}},
	{ area_name = "Sala_Comando",	                area_arg = 83,	area_life = 80, area_fire = { pos = {30.0, 12.0, 0.0}, size = 1.5}},
--------- 4 Torri Binate da 380mm	
	{ area_name = "Torre_380_Anton",		area_arg = 96,	area_life = 60, area_fire = { pos = {35.0, 5.0, 0.0}, size =  1.5}},
        { area_name = "Ponte Poppa",		       area_arg = 85,	area_life = 60, area_fire = { pos = {-45.0, 3.0, 0.0}, size = 1.5}}, 	
---- Fletcher sink	
	{ area_name = "Fletcher_Distrutta",    area_arg = 77,	area_life = 60, area_fire = { pos = {5.0, 12.0, 0.0}, size = 2.5}},

}





---------------------------------------------------------------------------------------------------------------------
------------          Specifiche Armamento 
---------------------------------------------------------------------------------------------------------------------
-- SK_C_33 (105 mm) naval artillery weapons. Source: https://en.wikipedia.org/wiki/10.5_cm_FlaK_38
-- Used default AK100 100mm Navy artillery weapon system as template with alterations
GT_t.WS_t.ship_SK_C_33 = {name = "10.5 cm FlaK 38"}
GT_t.WS_t.ship_SK_C_33.angles = {
					{math.rad(180), math.rad(-180), math.rad(-3), math.rad(85)},
					};
GT_t.WS_t.ship_SK_C_33.omegaY = 0.6
GT_t.WS_t.ship_SK_C_33.omegaZ = 0.6
GT_t.WS_t.ship_SK_C_33.reference_angle_Z = 0
GT_t.WS_t.ship_SK_C_33.LN = {}
GT_t.WS_t.ship_SK_C_33.LN[1] = {}
GT_t.WS_t.ship_SK_C_33.LN[1].type = 3
GT_t.WS_t.ship_SK_C_33.LN[1].distanceMin = 50
GT_t.WS_t.ship_SK_C_33.LN[1].max_trg_alt =20
GT_t.WS_t.ship_SK_C_33.LN[1].reactionTime = 15
GT_t.WS_t.ship_SK_C_33.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_SK_C_33.LN[1].sensor, GT_t.WSN_t[3])
GT_t.WS_t.ship_SK_C_33.LN[1].PL = {}
GT_t.WS_t.ship_SK_C_33.LN[1].PL[1] = {}
GT_t.WS_t.ship_SK_C_33.LN[1].PL[1].ammo_capacity = 240 -- Currently uses same ammo count as SK_C_38
GT_t.WS_t.ship_SK_C_33.LN[1].PL[1].shell_name = {"AK100_100"}; -- Currently uses AK100 100 mm shells (105 mm ammo is WIP)
GT_t.WS_t.ship_SK_C_33.LN[1].PL[1].shot_delay = 60/16.5 -- (16.5 rounds per minute per barrel)
GT_t.WS_t.ship_SK_C_33.LN[1].automaticLoader = false;
GT_t.WS_t.ship_SK_C_33.LN[1].reload_time = 240 * 20
GT_t.WS_t.ship_SK_C_33.LN[1].BR = { {pos = {8, 0, 0.1} }, {pos = {8, 0, -0.1} } }



-- Source for modifications: https://en.wikipedia.org/wiki/German_battleship_Bismarck
-- ship_FlaK38 (20 mm) naval AAA weapons. Source: https://en.wikipedia.org/wiki/2_cm_Flak_30/38/Flakvierling
-- Used default Mark 15 CIWS Phalanx Block 1 weapon system as template with alterations
GT_t.WS_t.ship_FlaK38 = {name = "2 cm FlaK 38"};
GT_t.WS_t.ship_FlaK38.angles = {
                    {math.rad(180), math.rad(-180), math.rad(-12), math.rad(90)},
                    };
GT_t.WS_t.ship_FlaK38.omegaY = math.rad(115) -- Block 1B
GT_t.WS_t.ship_FlaK38.omegaZ = math.rad(116) -- Block 1B
GT_t.WS_t.ship_FlaK38.pidY = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_FlaK38.pidZ = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_FlaK38.reference_angle_Z = 0
GT_t.WS_t.ship_FlaK38.LN = {}
GT_t.WS_t.ship_FlaK38.LN[1] = {}
GT_t.WS_t.ship_FlaK38.LN[1].type = 3
GT_t.WS_t.ship_FlaK38.LN[1].distanceMin = 10
GT_t.WS_t.ship_FlaK38.LN[1].distanceMax = 1500 -- effective shooting with 3600 meters
GT_t.WS_t.ship_FlaK38.LN[1].max_trg_alt = 1000
GT_t.WS_t.ship_FlaK38.LN[1].reactionTime = 1.8
GT_t.WS_t.ship_FlaK38.LN[1].beamWidth = math.rad(1);
GT_t.WS_t.ship_FlaK38.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_FlaK38.LN[1].sensor, GT_t.WSN_t[3])
GT_t.WS_t.ship_FlaK38.LN[1].PL = {}
GT_t.WS_t.ship_FlaK38.LN[1].PL[1] = {}
GT_t.WS_t.ship_FlaK38.LN[1].PL[1].ammo_capacity = 1550;
GT_t.WS_t.ship_FlaK38.LN[1].PL[1].shell_name = {"Rh202_20_AP", "Rh202_20_HE"};
GT_t.WS_t.ship_FlaK38.LN[1].PL[1].shell_display_name = "20mm AP+HE";
GT_t.WS_t.ship_FlaK38.LN[1].PL[1].shot_delay = 60/800 -- 3000rpm for Block 0, 4500rpm for Block 1
GT_t.WS_t.ship_FlaK38.LN[1].PL[1].reload_time = 1000000; -- never during the mission (ship autogun)
GT_t.WS_t.ship_FlaK38.LN[1].BR = { {pos = {3.478, 0, 0} }, }


-- SK_C_28 (150 mm) naval artillery weapons. Source: https://en.wikipedia.org/wiki/15_cm_SK_C/28
-- Used default FMC5 MK45 127mm Navy artillery weapon system as template with alterations
GT_t.WS_t.ship_SK_C_28 = {name = "15 cm SK C/28"}
GT_t.WS_t.ship_SK_C_28.angles = {
					{math.rad(135), math.rad(-135), math.rad(-10), math.rad(40)},
					};
GT_t.WS_t.ship_SK_C_28.omegaY = 0.6
GT_t.WS_t.ship_SK_C_28.omegaZ = 0.6
GT_t.WS_t.ship_SK_C_28.reference_angle_Z = 0
GT_t.WS_t.ship_SK_C_28.LN = {}
GT_t.WS_t.ship_SK_C_28.LN[1] = {}
GT_t.WS_t.ship_SK_C_28.LN[1].type = 6
GT_t.WS_t.ship_SK_C_28.LN[1].xc = 3
GT_t.WS_t.ship_SK_C_28.LN[1].distanceMin = 50
GT_t.WS_t.ship_SK_C_28.LN[1].max_trg_alt = 7500
GT_t.WS_t.ship_SK_C_28.LN[1].reactionTime = 15
GT_t.WS_t.ship_SK_C_28.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_SK_C_28.LN[1].sensor, GT_t.WSN_t[10])
GT_t.WS_t.ship_SK_C_28.LN[1].PL = {}
GT_t.WS_t.ship_SK_C_28.LN[1].PL[1] = {}
GT_t.WS_t.ship_SK_C_28.LN[1].PL[1].ammo_capacity = 240 -- Currently uses same ammo count as SK_C_38
GT_t.WS_t.ship_SK_C_28.LN[1].PL[1].shell_name = {"MK45_127"}; -- Currently uses MK45 127 mm shells (150 mm ammo is WIP)
GT_t.WS_t.ship_SK_C_28.LN[1].PL[1].shot_delay = 60/7.5 -- (7.5 rounds per minute per barrel)
GT_t.WS_t.ship_SK_C_28.LN[1].automaticLoader = false;
GT_t.WS_t.ship_SK_C_28.LN[1].reload_time = 240 * 20
GT_t.WS_t.ship_SK_C_28.LN[1].BR = { {pos = {8, 0, 0.1} }, {pos = {8, 0, -0.1} } }


-- SK_C_34 (380 mm) naval artillery weapons. Source: https://en.wikipedia.org/wiki/38_cm_SK_C/34_naval_gun
-- Used default AK130 130mm Navy artillery weapon system as template with alterations
GT_t.WS_t.ship_SK_C_34 = {name = "38 cm SK C/34"}
GT_t.WS_t.ship_SK_C_34.angles = {
					{math.rad(150), math.rad(-150), math.rad(-5.5), math.rad(30)},
					};
GT_t.WS_t.ship_SK_C_34.omegaY = 0.6
GT_t.WS_t.ship_SK_C_34.omegaZ = 0.6
GT_t.WS_t.ship_SK_C_34.reference_angle_Z = 0
GT_t.WS_t.ship_SK_C_34.LN = {}
GT_t.WS_t.ship_SK_C_34.LN[1] = {}
GT_t.WS_t.ship_SK_C_34.LN[1].type = 6
GT_t.WS_t.ship_SK_C_34.LN[1].distanceMin = 50
GT_t.WS_t.ship_SK_C_34.LN[1].max_trg_alt = 20
GT_t.WS_t.ship_SK_C_34.LN[1].reactionTime = 15
GT_t.WS_t.ship_SK_C_34.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_SK_C_34.LN[1].sensor, GT_t.WSN_t[10])
GT_t.WS_t.ship_SK_C_34.LN[1].PL = {}
GT_t.WS_t.ship_SK_C_34.LN[1].PL[1] = {}
GT_t.WS_t.ship_SK_C_34.LN[1].PL[1].ammo_capacity = 240
GT_t.WS_t.ship_SK_C_34.LN[1].PL[1].shell_name = {"A222_130"}; -- Currently uses A222 130 mm shells (380 mm ammo is WIP)
--GT_t.WS_t.ship_SK_C_34.LN[1].PL[1].shell_name = {"Shell_380mm_bismark"};

GT_t.WS_t.ship_SK_C_34.LN[1].PL[1].shot_delay = 60/2.5 -- (2.5 rounds per minute per barrel)
GT_t.WS_t.ship_SK_C_34.LN[1].automaticLoader = false;
GT_t.WS_t.ship_SK_C_34.LN[1].reload_time = 240 * 20
GT_t.WS_t.ship_SK_C_34.LN[1].BR = { {pos = {8, 0, 0.1} }, {pos = {8, 0, -0.1} } }
-------------------------------------------------------------------------------------------
--  Armi
-------------------------------------------------------------------------------------------
-- weapon systems
GT.WS = {}
local ws;
GT.WS.maxTargetDetectionRange = 450000;
GT.WS.radar_type = 102


---------------------------------------------------------------------------------------------------------------------------------------
----------------------------------------- 3 postazoni Binate  -------------------------------------------------------------------------
--- Mini GUN di PRUA lato Sinistro Prua
--------------------------------------------------------------------------------------------------------------------------------------- 


ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FlaK38 )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_2_Mk_VIII )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_06'
GT.WS[ws].drawArgument1 = 49
GT.WS[ws].drawArgument2 = 50
GT.WS[ws].angles[1][1] = math.rad(150);
GT.WS[ws].angles[1][2] = math.rad(-10);
GT.WS[ws].reference_angle_Y = math.rad(35);  -- valore originale 90
GT.WS[ws].LN[1].fireAnimationArgument = 127;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_MGUN_1_1',
		recoilArgument = 127,
	},
	{
		connector_name = 'POINT_MGUN_1_2',
		recoilArgument = 127,
	}
}
---------------------------------------------------------------------------------------------------------------------------------------
--- Mini GUN di PRUA lato Destro Prua

ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FlaK38 )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_2_Mk_VIII )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_07'
GT.WS[ws].drawArgument1 = 51
GT.WS[ws].drawArgument2 = 52
GT.WS[ws].angles[1][1] = math.rad(-10);
GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].reference_angle_Y = math.rad(-35);  -- valore originale 90
GT.WS[ws].LN[1].fireAnimationArgument = 128;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_MGUN_2_1',
		recoilArgument = 128,
	},
	{
		connector_name = 'POINT_MGUN_2_2',
		recoilArgument = 128,
	}
}
---------------------------------------------------------------------------------------------------------------------------------------
--- Mini GUN di PRUA Centrale

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_08'
GT.WS[ws].drawArgument1 = 53
GT.WS[ws].drawArgument2 = 54
---GT.WS[ws].angles[1][1] = math.rad(150);
---GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].angles = {
					{math.rad(150), math.rad(0),      math.rad(-10), math.rad(87)},
					{math.rad(-0),  math.rad(-150), math.rad(-10), math.rad(87)},
					};
GT.WS[ws].reference_angle_Y = math.rad(0);  
GT.WS[ws].LN[1].fireAnimationArgument = 129;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_MGUN_3_1',
		recoilArgument = 129,
	},
	{
		connector_name = 'POINT_MGUN_3_2',
		recoilArgument = 129,
	}
}


---------------------------------------------------------------------------------------------------------------------------------------
----------------------------------------- 6   Mitragliatrici Antieree singole ---------------------------------------------------------
--- Mini GUN di PRUA lato Sinistro Prua
--------------------------------------------------------------------------------------------------------------------------------------- 
--- 1 Sx 
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FlaK38 )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_2_Mk_VIII )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_09'
GT.WS[ws].drawArgument1 = 55
GT.WS[ws].drawArgument2 = 56
GT.WS[ws].angles[1][1] = math.rad(150);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(35);  
GT.WS[ws].LN[1].fireAnimationArgument = 130;
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_MGUN_4'
GT.WS[ws].LN[1].BR[1].recoilTime = 1;

-- 2 Sx 
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FlaK38 )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_2_Mk_VIII )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_10'
GT.WS[ws].drawArgument1 = 57
GT.WS[ws].drawArgument2 = 58
GT.WS[ws].angles[1][1] = math.rad(150);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(35);  
GT.WS[ws].LN[1].fireAnimationArgument = 131;
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_MGUN_5'
GT.WS[ws].LN[1].BR[1].recoilTime = 1;

-- 3 Sx Poppa
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FlaK38 )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_2_Mk_VIII )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_11'
GT.WS[ws].drawArgument1 = 59
GT.WS[ws].drawArgument2 = 60
GT.WS[ws].angles[1][1] = math.rad(18);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(135);  
GT.WS[ws].LN[1].fireAnimationArgument = 132;
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_MGUN_6'
GT.WS[ws].LN[1].BR[1].recoilTime = 1;

-- 4 Dx 
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FlaK38 )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_2_Mk_VIII )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_12'
GT.WS[ws].drawArgument1 = 61
GT.WS[ws].drawArgument2 = 62
GT.WS[ws].angles[1][1] = math.rad(0);
GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].reference_angle_Y = math.rad(-35);  
GT.WS[ws].LN[1].fireAnimationArgument = 133;
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_MGUN_7'
GT.WS[ws].LN[1].BR[1].recoilTime = 1;

-- 5 Dx 
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FlaK38 )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_2_Mk_VIII )
GT.WS[ws].area = 'Ponte Poppa'
GT.WS[ws].center = 'CENTER_TOWER_13'
GT.WS[ws].drawArgument1 = 63
GT.WS[ws].drawArgument2 = 64
GT.WS[ws].angles[1][1] = math.rad(0);
GT.WS[ws].angles[1][2] = math.rad(180);
GT.WS[ws].reference_angle_Y = math.rad(150);  
GT.WS[ws].LN[1].fireAnimationArgument = 134;
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_MGUN_8'
GT.WS[ws].LN[1].BR[1].recoilTime = 1;

-- 6 Dx Poppa
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FlaK38 )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_2_Mk_VIII )
GT.WS[ws].area = 'Ponte Poppa'
GT.WS[ws].center = 'CENTER_TOWER_14'
GT.WS[ws].drawArgument1 = 65
GT.WS[ws].drawArgument2 = 66
GT.WS[ws].angles[1][1] = math.rad(-180);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(-150);  
GT.WS[ws].LN[1].fireAnimationArgument = 135;
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_MGUN_9'
GT.WS[ws].LN[1].BR[1].recoilTime = 1;

----------------------------------------------------------------------------------------------------------------------------------------------------------
-- 5 Torrette Principali
--------------  Torretta Cannone di Prua 1 ----------------------------------------------------------------------------------------------------

ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_28 )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_4_Mk_XVI )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FMC5 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_28 )
GT.WS[ws].area = 'Torre_380_Anton'
GT.WS[ws].center = 'CENTER_TOWER_01'
GT.WS[ws].drawArgument1 = 0
GT.WS[ws].drawArgument2 = 1
GT.WS[ws].angles[1][1] = math.rad(150);
GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_GUN_01'
GT.WS[ws].LN[1].BR[1].recoilArgument = 33;
----GT.WS[ws].LN[1].BR[1].recoilTime = 0.2;  --- valore originale
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;

----------------------------------------------------------------------------------------------------------------------------------------
-------------  Torretta Cannone di Prua 2 ---------------------------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_28 )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_4_Mk_XVI )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FMC5 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_28 )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_02'
GT.WS[ws].drawArgument1 = 13
GT.WS[ws].drawArgument2 = 14
GT.WS[ws].angles[1][1] = math.rad(150);
GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_GUN_02'
GT.WS[ws].LN[1].BR[1].recoilArgument = 34;
----GT.WS[ws].LN[1].BR[1].recoilTime = 0.2;  --- valore originale
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
----------------------------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------------------
--- Torrette di Poppa
--- Torretta Cannone di Poppa 3 ------------------------------------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_28 )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_4_Mk_XVI )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FMC5 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_28 )
GT.WS[ws].area = 'Strutture_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_03'
GT.WS[ws].drawArgument1 = 15
GT.WS[ws].drawArgument2 = 16
GT.WS[ws].reference_angle_Y = math.rad(0);
GT.WS[ws].angles = {
					{math.rad(130), math.rad(30),      math.rad(-5), math.rad(75)},
					{math.rad(-30),  math.rad(-150), math.rad(-5), math.rad(75)},
					};
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_GUN_03'
GT.WS[ws].LN[1].BR[1].recoilArgument = 35;
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;

--- Torretta Cannone di Poppa  4 -----------------------------------------------------------------------------------------

ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_28 )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_4_Mk_XVI )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FMC5 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_28 )
GT.WS[ws].area = 'Strutture_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_04'
GT.WS[ws].drawArgument1 = 17
GT.WS[ws].drawArgument2 = 18
GT.WS[ws].reference_angle_Y = math.rad(180);
GT.WS[ws].angles[1][1] = math.rad(-45);
GT.WS[ws].angles[1][2] = math.rad(45);
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_GUN_04'
GT.WS[ws].LN[1].BR[1].recoilArgument = 36;
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;


--- Torretta Cannone di Poppa  5 --------------------------------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_28 )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_4_Mk_XVI )
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FMC5 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_28 )
GT.WS[ws].area = 'Ponte Poppa'
GT.WS[ws].center = 'CENTER_TOWER_05'
GT.WS[ws].drawArgument1 = 19
GT.WS[ws].drawArgument2 = 20
GT.WS[ws].reference_angle_Y = math.rad(180);
GT.WS[ws].angles[1][1] = math.rad(-45);
GT.WS[ws].angles[1][2] = math.rad(45);
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_GUN_05'
GT.WS[ws].LN[1].BR[1].recoilArgument = 37;
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;

-------------------------------------------------------------------------------------------------------------------------------------

GT.Name = "uss_franklin"
GT.DisplayName = _("USS Franklin -Big Ben-")
GT.Rate = 5500.000000

GT.Sensors = {  OPTIC = {"long-range naval optics", "long-range naval LLTV", "long-range naval FLIR","generic tank daysight",},
                RADAR = {
                    "Patriot str",
                    "ticonderoga search radar",
                },
            };

GT.DetectionRange  = GT.airFindDist;
GT.ThreatRange = GT.airWeaponDist;
GT.Singleton   ="yes";
GT.mapclasskey = "P0091000065";


   

GT.attribute = {wsType_Navy,wsType_Ship,wsType_AirCarrier,WSTYPE_PLACEHOLDER,                           --  WSTYPE_PLACEHOLDER,                      --Kuznecow,
                    "Aircraft Carriers",
                    "Arresting Gear",
--					"catapult",
         			"RADAR_BAND1_FOR_ARM",
                    "RADAR_BAND2_FOR_ARM",
					"DetectionByAWACS"
				};			
GT.Categories = {
					{name = "AircraftCarrier"},
					{name = "AircraftCarrier With Catapult"},
					{name = "Armed Ship"},
                    {name = "AircraftCarrier With Tramplin"},
	                {name = "HelicopterCarrier"}
};


   
 
--------------------------------------------------------------------------------

        
add_surface_unit(GT)

GT.RunWays =
{     
-- landing strip definition (first in table)   ----- note by baco30: Player or Client starts always at same pos abeam of island. ??

--	VppStartPoint; 					azimuth (degree} 	Length_Vpp; 	Width_Vpp;
	{{-44.54,	 16.26, -2.00}, 		0.0, 			240.0, 			25.0, 		
-- alsArgument, lowGlidePath, slightlyLowGlidePath, onLowerGlidePath, onUpperGlidePath, slightlyHighGlidePath, highGlidePath
	0, 			0, 		  		0, 					0, 			 0, 				0, 				0},
-- runways
	{{-10.00,	16.26,  0.0},        359.0, 			    120.0,     		  25.0, 0, 0, 0, 0, 0, 0, 0}, -- edited by baco30 to fit 4 planes "T/O from rwy" 
	{{-20.00,	16.26, -8.0},        359.0, 			    120.0, 			  25.0, 0, 0, 0, 0, 0, 0, 0}, -- pos. 2: is for 3rd unit by default
	{{-30.00,	16.26,  0.0},  		359.0, 			    120.0, 			  25.0, 0, 0, 0, 0, 0, 0, 0}, -- you can correct on Mission Editor unit's wpt option table
	{{-40.00,	16.26, -8.0}, 	    359.0, 		        120.0, 		      25.0, 0, 0, 0, 0, 0, 0, 0}, -- 

};
GT.RunWays.RunwaysNumber = #GT.RunWays

---- note added by baco30:  up to 8 planes can appear toghether 4 T/O from rwy + 4 cold or hot start,
----                        but, as per OB 2.5.6, the secound air group will make a system crash when the 2nd air unit move for TO.
----						

--GT.TaxiRoutes = 
	-- taxi routes and parking spots in LCS
	--    x				y        z			V_target
--{					
--	{ -- 1 parking spot
--		{{-10.10, 	16.26,		-1.0},		0.0},
--		{{-10.00,	16.26,		-1.0},		0.0}
--	},
--	{ -- 2 parking spot
--		{{-10.10, 	16.26,		-8.0},		0.0},
--		{{-10.00,	16.26,		-8.0},		0.0}
--		
--	},
--	{ -- 3 parking spot
--		{{-10.10,	16.26,		-1.0},      0.0},
--		{{-10.00,	16.26,		-1.0},    	0.0}
--		
--	},
--	{ -- 4 parking spot
--		{{-10.10,	16.26,	     -8.0},		0.0},
--		{{-10.00,	16.26,		 -8.0},		0.0}
--		
--	},
--}
--GT.TaxiRoutes.RoutesNumber = #GT.TaxiRoutes


GT.TaxiForTORoutes = 
	-- taxi routes and parking spots in LCS     ----   edited by baco30 to fit 2 groups=8 planes on ramp cold of hot (but cannot t/o due to bug OB 2.5.6)
	--    x				y        z			V_target
	{		
	{ RunwayIdx = 1, Points =
		{  
			-- spawn spot1
			{{ -51.0,	16.26,		0},		4.0},
			{{ -51.0,	16.26,		0},		4.0},
				}
	},
	{ RunwayIdx = 2, Points =
		{ -- spawn spot2
			{{ -62.0,	16.26,		-8},		4.0},
			{{ -62.0,	16.26,		 -8},		4.0},		
			
		}
	},
	{ RunwayIdx = 3, Points =
		{ -- spawn spot3
			{{ -73,	16.26,		0},		4.0},
			{{ -73,	16.26,		0},		4.0},
			
		}
	},
	{ RunwayIdx = 4, Points =
		{ -- spawn spot 4
			{{-84,	16.26,		-8},		4.0},
			{{-84,	16.26,		-8},		4.0},
			
		}
	},
	{ RunwayIdx = 5, Points =
		{ -- spawn spot5
			{{ -95,	16.26,		0},		4.0},
			{{ -95,	16.26,		0},		4.0},
			
		}
	},
	{ RunwayIdx = 6, Points =
		{ -- spawn spot 6
			{{-106,	16.26,		-8},		4.0},
			{{-106,	16.26,		-8},		4.0},
			
		}
	},
	{ RunwayIdx = 7, Points =
		{ -- spawn spot 6
			{{-117,	16.26,		0},		4.0},
			{{-117,	16.26,		0},		4.0},
			
		}
	},
	{ RunwayIdx = 8, Points =
		{ -- spawn spot 6
			{{-128,	16.26,		-8},		4.0},
			{{-128,	16.26,		-8},		4.0},
			
		}
	},
}
GT.TaxiForTORoutes.RoutesForTONumber = #GT.TaxiForTORoutes